/*
 * clGeniviAudioCtrlAdapter.cpp
 *
 *  Created on: Jul 25, 2013
 *      Author: vo84hi
 */

//#include "IAmControlReceiver.h"
#include "AudioStack/clGeniviAudioCtrlAdapter.h"
#include "AudioStack/clAudioSMEngine.h"
#include "AudioStack/clAudioSourceController.h"
#include "amcontrol_clienthandler_fc_audioroutemanager.h"
#include "AudioStack/AudioSources/clAudioSourceFactory.h"
#include <sstream>



#include <stdio.h>
//#include <malloc.h>
#include <expat.h>

#ifndef USE_DLT_TRACE
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
   #define ETG_I_TTFIS_CMD_PREFIX "AudioStack_"

   #define ETG_I_TRACE_CHANNEL TR_TTFIS_CDC
#define ETG_DEFAULT_TRACE_CLASS TR_COMP_AUDIOSTACK
#include "trcGenProj/Header/clGeniviAudioCtrlAdapter.cpp.trc.h"
#endif


#define G3G_NUMBER_SOURCE_SND_PROPERTY 3
#define G3G_NUMBER_SINK_SND_PROPERTY 22

#define G3G_DEFAULT_SND_PROPERTY_VALUE 0

uint8_t g_u8SrcSoundPropertiesId[G3G_NUMBER_SOURCE_SND_PROPERTY]={
                               MSP_MIC_STATUS_CONNECTION,MSP_MIC_STATUS_LEVEL,MSP_LEVEL_AUX_IN
                            };

uint8_t g_u8SinkSoundPropertiesId[G3G_NUMBER_SINK_SND_PROPERTY]={
                               MSP_SOUND_BASS,MSP_SOUND_BASS_RELATIVE,MSP_SOUND_MIDDLE,MSP_SOUND_MIDDLE_RELATIVE,
                               MSP_SOUND_TREBLE,MSP_SOUND_TREBLE_RELATIVE,MSP_SOUND_LOUDNESS,MSP_SOUND_LOUDNESS_RELATIVE,
                               MSP_SOUND_BALANCE,MSP_SOUND_BALANCE_RELATIVE,MSP_SOUND_FADER,MSP_SOUND_FADER_RELATIVE,
                               MSP_SOUND_DYN_COMPRESSION,MSP_EQUALIZER_PRESET,MSP_SPEED_DEPENDENT_VOLUME,
                               MSP_SOUND_OPTIMIZATION,MSP_SOUND_ROOM_EFFECT,MSP_LEVEL_BEEP,MSP_LEVEL_CENTER,
                               MSP_LEVEL_SUBWOOFER,MSP_SETTING_SURROUND,MSP_MODE_AUDIO
                             };

namespace AudioStack
{

using namespace am;

std::map<am_sourceID_t, SourceID >            clGeniviAudioCtrlAdapter::m_registeredSources;
IAmControlReceive*                            clGeniviAudioCtrlAdapter::m_geniviControlIF            = NULL;
amcontrol_clienthandler_fc_audioroutemanager* clGeniviAudioCtrlAdapter::m_clientHandlerAudioRouteMgr = NULL;
am_domainID_t                                 clGeniviAudioCtrlAdapter::m_domainID                   = 0;

tVoid clGeniviAudioCtrlAdapter::Init(IAmControlReceive * pGeniviCtrlIF,
      amcontrol_clienthandler_fc_audioroutemanager* clientHandlerAudioRouteMgr)
{
#ifndef USE_DLT_TRACE
   ET_TRACE_OPEN;
   ETG_I_REGISTER_FILE();

   ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "SRC_ON %d %d"
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_SRC_ON)
            , ETG_I_ENUM(AudioStack::AudioSources::enAudioSources)
            , tU16))

   ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "SRC_OFF %d %d"
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_SRC_OFF)
            , ETG_I_CENUM(AudioSources::enAudioSources)
            , tU16))

   ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "SRC_SET_AVAILABLE %d %d"
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_SET_SRC_AVAILABLE)
            , ETG_I_CENUM(AudioSources::enAudioSources)
            , tU16))

   ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "SRC_SET_NOT_AVAILABLE %d %d"
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_SET_SRC_NOT_AVAILABLE)
            , ETG_I_CENUM(AudioSources::enAudioSources)
            , tU16))

   ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "SRC_SET_AVAILABLE_UNKNOWN %d %d"
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_SET_SRC_AVAILABLE_UNKOWN)
            , ETG_I_CENUM(AudioSources::enAudioSources)
            , tU16))

   ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "SET_RUNLVL %d "
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_SET_RUNLEVEL)
            , tU16))

   ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "GET_RUNLVL "
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_GET_RUNLEVEL) ))

   ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "RESET "
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_RESET) ))

   ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "PRINT "
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_PRINT) ))

   ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "LIST_SRCs "
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_SRC_LIST) ))

   ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "KILL_SRC %d %d "
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_KILL_SRC)
            , ETG_I_ENUM(AudioStack::AudioSources::enAudioSources)
            , tU16))

   ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "READ_XML "
               , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_READXML) ))

   ETG_I_REGISTER_CHN(vTraceRxDefault);

#endif

   ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::Init: domainID %d", m_domainID));
   AddGeniviCtrlIF(pGeniviCtrlIF);
   AddAudioRouteMgrIF(clientHandlerAudioRouteMgr);
   //am_Error_e eCode;

   if(m_domainID)
   {
      //initializeSourceClasses(m_domainID);
      initializeSinks(m_domainID);
      //initializeSources(m_domainID);
      clAudioSMEngine::SetRunlevel(3);
   }
}

tVoid clGeniviAudioCtrlAdapter::vTraceRxDefault(tPCUChar pcu8Data){
   ETG_TRACE_FATAL(("vTraceRx() unknown trace command= %x" ,
       ETG_LIST_LEN((tU8)pcu8Data[0]), ETG_LIST_PTR_T8(&pcu8Data[1]) ));
}

tVoid clGeniviAudioCtrlAdapter::TTFisInput(tU8 cmd,tU16 value1,tU16 value2)
{
   ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::TTFisInput cmd %d value1 %d, value2 %d", cmd, value1, value2));
   clGeniviAudioCtrlAdapter::enCommand enCmd = static_cast<clGeniviAudioCtrlAdapter::enCommand>(cmd);
   switch(cmd)
   {
      case clGeniviAudioCtrlAdapter::CMD_SRC_ON:
         clAudioSMEngine::Source_On(SourceID(static_cast<AudioSources::enAudioSources>(value1),value2));
         break;
      case clGeniviAudioCtrlAdapter::CMD_SRC_OFF:
         clAudioSMEngine::Source_Off(SourceID(static_cast<AudioSources::enAudioSources>(value1),value2));
         break;
      case clGeniviAudioCtrlAdapter::CMD_RESET:
         clAudioSMEngine::ResetStack();
         break;
      case clGeniviAudioCtrlAdapter::CMD_PRINT:
         clAudioSMEngine::TraceStack();
         break;
      case clGeniviAudioCtrlAdapter::CMD_SET_RUNLEVEL:
         if(value1>3)
         {
            ETG_TRACE_ERR(("clGeniviAudioCtrlAdapter::TTFisInput : Runlevel must be 0-3"));
            return;
         }
         clAudioSMEngine::SetRunlevel(value1);
         break;
      case clGeniviAudioCtrlAdapter::CMD_GET_RUNLEVEL:
         clAudioSMEngine::GetRunlevel();
         break;
      case clGeniviAudioCtrlAdapter::CMD_KILL_SRC:
         clAudioSMEngine::vHandleSrcActError(SourceID(static_cast<AudioSources::enAudioSources>(value1),value2));
         break;
      case clGeniviAudioCtrlAdapter::CMD_SRC_LIST:
         clAudioSMEngine::ListSources();
         break;
      case clGeniviAudioCtrlAdapter::CMD_SET_SRC_AVAILABLE:
         clAudioSMEngine::Source_AvailabilityChange(SourceID(static_cast<AudioSources::enAudioSources>(value1),value2),
               clAudioSource::available,
               clAudioSource::newmedia);
         break;
      case clGeniviAudioCtrlAdapter::CMD_SET_SRC_NOT_AVAILABLE:
         clAudioSMEngine::Source_AvailabilityChange(SourceID(static_cast<AudioSources::enAudioSources>(value1),value2),
               clAudioSource::not_available,
               clAudioSource::nomedia);
         break;
      case clGeniviAudioCtrlAdapter::CMD_SET_SRC_AVAILABLE_UNKOWN:
         clAudioSMEngine::Source_AvailabilityChange(SourceID(static_cast<AudioSources::enAudioSources>(value1),value2),
               clAudioSource::unkonwn,
               clAudioSource::newmedia);
         break;
      case clGeniviAudioCtrlAdapter::CMD_READXML:
         clGeniviAudioCtrlAdapter::ReadXML();
         break;
      default:
         ETG_TRACE_ERR(("clGeniviAudioCtrlAdapter::TTFisInput Command not handled"));
         break;
   }
}

void clGeniviAudioCtrlAdapter::ReadXML()
{
   ETG_TRACE_ERR(("ReadXML"));
     char buf[255];
     FILE * in;
     XML_Parser parser;

     if (!(in = fopen ("/tmp/test.xml", "r"))) {
        ETG_TRACE_ERR (("ReadXML: Unable to open input file" ));
        return;
     }

     parser = XML_ParserCreate(NULL);
//     XML_SetElementHandler(parser, startElement, endElement);

//     XML_SetElementHandler(parser, startElement, endElement);
//     if (emit_content) XML_SetCharacterDataHandler(parser, charData);
//
//     done = 0;
//     finished = 0;
//
//     do {
//        size_t len = fread(buf, 1, sizeof(buf), in);
//        done = len < sizeof(buf);
//        if (!XML_Parse(parser, buf, len, done)) {
//           fprintf(stderr,
//              "%s at line %d\n",
//              XML_ErrorString(XML_GetErrorCode(parser)),
//              XML_GetCurrentLineNumber(parser));
//           return 1;
//        }
//     } while (!done && !finished);
//     XML_ParserFree(parser);
//
//     free_stack();
//
//     if (emit_tags) printf ("\n");
//
//     if (in != stdin) fclose (in);
//     return 0;

}

tVoid clGeniviAudioCtrlAdapter::initializeSinks(am_domainID_t domainID)
{
   am_Error_e eCode;

   //create sink
   am_Sink_s sink;
   sink.domainID     = domainID; //we cannot know this when the table is created !
   sink.name         = "AMPLIFIER_MAINFIELD";
   sink.sinkID       = 1; //take fixed ids to make thins easy
   sink.sinkClassID  = 1;
   sink.volume       = 0;
   sink.available.availability       = A_AVAILABLE;
   sink.available.availabilityReason = AR_UNKNOWN;
   //sink.listSoundProperties.push_back(sp);

  std::vector<am_MainSoundProperty_s> listMainSoundProperties;
  am_MainSoundProperty_s msp;
  msp.value = G3G_DEFAULT_SND_PROPERTY_VALUE;

  for (uint16_t i16Src = 0; i16Src < G3G_NUMBER_SINK_SND_PROPERTY; i16Src++)
  {
    msp.type = (am_MainSoundPropertyType_e)g_u8SinkSoundPropertiesId[i16Src];
    listMainSoundProperties.push_back(msp);
  }

  sink.listMainSoundProperties = listMainSoundProperties;

   sink.visible = true;
   sink.listConnectionFormats.push_back(CF_STEREO);
   sink.muteState = MS_MUTED;
   sink.mainVolume = 0;

   //sinks
   am_sinkID_t sinkID;
   //set the correct domainID
   //sinkIter->domainID = mListDomains[0].domainID;

   if ((eCode =
         m_geniviControlIF->enterSinkDB(sink, sinkID)) != E_OK)
   {
      logError("syncRegisterWorker::start2work error on registering domain, failed with", eCode);
   }
}

am_Error_e clGeniviAudioCtrlAdapter::addSourceClass( am_SourceClass_s& srcClass, am_sourceClass_t& srcClassID)
{
      return m_geniviControlIF->enterSourceClassDB(srcClassID, srcClass);
}

tVoid clGeniviAudioCtrlAdapter::initializeSourceClasses(am_domainID_t)
{
   am_Error_e eCode;
   am_SourceClass_s srcClass;
   am_sourceClass_t srcClassID;

   srcClass.sourceClassID = static_cast<am_sourceClass_t>(clStackRules::typeBg);
   srcClass.name = "BG";
   if ((eCode =
         m_geniviControlIF->enterSourceClassDB(srcClassID, srcClass) ) != E_OK)
   {
      logError("error on registering sourceClass, failed with", eCode);
   }

   srcClass.sourceClassID = static_cast<am_sourceClass_t>(clStackRules::typeFg);
   srcClass.name = "FG";
   if ((eCode =
         m_geniviControlIF->enterSourceClassDB(srcClassID, srcClass) ) != E_OK)
   {
      logError("error on registering sourceClass, failed with", eCode);
   }

   srcClass.sourceClassID = static_cast<am_sourceClass_t>(clStackRules::typeMix);
   srcClass.name = "MIX";
   if ((eCode =
         m_geniviControlIF->enterSourceClassDB(srcClassID, srcClass) ) != E_OK)
   {
      logError("error on registering sourceClass, failed with", eCode);
   }

   srcClass.sourceClassID = static_cast<am_sourceClass_t>(clStackRules::typeUI);
   srcClass.name = "UI";
   if ((eCode =
         m_geniviControlIF->enterSourceClassDB(srcClassID, srcClass) ) != E_OK)
   {
      logError("error on registering sourceClass, failed with", eCode);
   }
}

tVoid clGeniviAudioCtrlAdapter::initializeSources(am_domainID_t domainID)
{
   if(m_geniviControlIF == NULL)
   {
      return;
   }
   am_Error_e eCode;



   //
   // CREATE DB SOURCE ITEM FOR EACH RULE OF THE STACKRULES
   // BUT EXCEPT GROUP IS INTERNAL
   //
   // as long as we do not have stl container we'll iterate through array
   int i = 0;
   do
   {
      if(clStackRules::rules[i].sourceRegistration == clStackRules::registerStatic)
      {
         //create a bunch full of sources
         am_Source_s item;
         am_sourceID_t sourceID;
         item.domainID = domainID; //assign the default domain we created
         item.name = AudioSources::SourceName[clStackRules::rules[i].src];
         item.sourceState = SS_OFF;
         item.sourceID = static_cast<am_sourceID_t>(clStackRules::rules[i].src); //take fixed ids to make thins easy
         //don't know Class ID
         item.sourceClassID = static_cast<am_sourceClass_t>(clStackRules::rules[i].type);
         item.volume = 0;
         item.visible = true;
         item.available.availability = A_AVAILABLE;
         item.available.availabilityReason = AR_UNKNOWN;

         am_MainSoundProperty_s msp;
         std::vector<am_MainSoundProperty_s> listMainSoundProperties;

         msp.value = G3G_DEFAULT_SND_PROPERTY_VALUE;

     for (uint16_t i16Src = 0; i16Src < G3G_NUMBER_SOURCE_SND_PROPERTY; i16Src++)
     {
      msp.type = (am_MainSoundPropertyType_e)g_u8SrcSoundPropertiesId[i16Src];
      listMainSoundProperties.push_back(msp);
     }
     item.listMainSoundProperties = listMainSoundProperties;
         item.listConnectionFormats.push_back(CF_STEREO);

         if ((eCode =
               m_geniviControlIF->enterSourceDB(item,sourceID)) != E_OK)
         {
            logError("syncRegisterWorker::start2work error on registering source, failed with", eCode);
         }
      }
      ++i;
   }
   while((clStackRules::rules[i].src != AudioSources::LAST)&&(i != AudioSources::LAST));
}

tVoid clGeniviAudioCtrlAdapter::Reset()
{
   m_geniviControlIF = NULL;
   //m_registeredSources.clear();
}

clAudioSource::enSourceActivity clGeniviAudioCtrlAdapter::Ext2Int_Activity(midw_fi_tcl_e8_SrcActivity::tenType extActivity)
{
   switch(extActivity)
   {
      case midw_fi_tcl_e8_SrcActivity::FI_EN_ON:
         return clGeniviAudioSource::On;

      case midw_fi_tcl_e8_SrcActivity::FI_EN_PAUSE:
         return clGeniviAudioSource::Pause;

      case midw_fi_tcl_e8_SrcActivity::FI_EN_OFF:
         return clGeniviAudioSource::Off;

      default:
         ETG_TRACE_FATAL(("Ext2Int_Activity INVALID PARAMETER"));
         break;
   }
   return clGeniviAudioSource::Off;
}

clAudioSource::enSourceAvailability clGeniviAudioCtrlAdapter::Ext2Int_Availability(midw_fi_tcl_e8_SrcAvailability::tenType extAvailability)
{
   switch(extAvailability)
   {
      case midw_fi_tcl_e8_SrcAvailability::FI_EN_NOT_AVAILABLE:
         return clAudioSource::not_available;
      case midw_fi_tcl_e8_SrcAvailability::FI_EN_PLAYABLE:
         return clAudioSource::available;
      case midw_fi_tcl_e8_SrcAvailability::FI_EN_PLAYABLE_UNKNOWN:
         return clAudioSource::unkonwn;
      case midw_fi_tcl_e8_SrcAvailability::FI_EN_NOT_PLAYABLE:
         return clAudioSource::not_available;
      default:
         ETG_TRACE_FATAL(("Ext2Int_Availability INVALID PARAMETER"));
         break;
   }
   return clAudioSource::not_available;
}

clAudioSource::enSourceAvailabilityReason clGeniviAudioCtrlAdapter::Ext2Int_AvailabilityReason(
      midw_fi_tcl_e8_SrcAvailabilityReason::tenType extAvailabilityReason)
{
   switch(extAvailabilityReason)
   {
      case midw_fi_tcl_e8_SrcAvailabilityReason::FI_EN_ERROR:
         return clAudioSource::error;
      case midw_fi_tcl_e8_SrcAvailabilityReason::FI_EN_NEWMEDIA:
         return clAudioSource::newmedia;
      case midw_fi_tcl_e8_SrcAvailabilityReason::FI_EN_NOMEDIA:
         return clAudioSource::nomedia;
      case midw_fi_tcl_e8_SrcAvailabilityReason::FI_EN_NO_CONTENT:
         return clAudioSource::no_content;
      case midw_fi_tcl_e8_SrcAvailabilityReason::FI_EN_SAMEMEDIA:
         return clAudioSource::samemedia;
      case midw_fi_tcl_e8_SrcAvailabilityReason::FI_EN_TEMPERATURE:
         return clAudioSource::temperature;
      case midw_fi_tcl_e8_SrcAvailabilityReason::FI_EN_VOLTAGE:
         return clAudioSource::voltage;
      default:
         ETG_TRACE_FATAL(("Ext2Int_AvailabilityReason INVALID PARAMETER"));
         break;
   }
   return clAudioSource::error;
}


am_sourceID_t clGeniviAudioCtrlAdapter::AddSource(SourceID srcID, am_Source_s& gam_source_s)
{
   ETG_TRACE_USR4(("AddSource: SourceClass: %d subID %#x(%d), GeniviID %d "
            ,ETG_CENUM(AudioSources::enAudioSources,static_cast<AudioSources::enAudioSources>(srcID.enSourceClass))
            , (tU16)srcID.u16SubSource
            , (tU16)srcID.u16SubSource
            , gam_source_s.sourceID));
   if(m_geniviControlIF == NULL)
   {
      ETG_TRACE_ERR(("Error: Genivi Receive Interface not available! SourceClass: %d subID %#x(%d) "
            ,ETG_CENUM(AudioSources::enAudioSources,static_cast<AudioSources::enAudioSources>(srcID.enSourceClass))
            , (tU16)srcID.u16SubSource
            , (tU16)srcID.u16SubSource));
      return 0;
   }
   am_sourceID_t gam_sourceID = gam_source_s.sourceID;
   am_Error_e retVal = m_geniviControlIF->enterSourceDB(gam_source_s,gam_sourceID);
   if(retVal == E_OK)
   {
      m_registeredSources[gam_sourceID] = srcID;
      ETG_TRACE_USR4(("AddSource: SourceClass: %d subID %#x(%d) assigned GeniviSourceID %d "
            ,ETG_CENUM(AudioSources::enAudioSources,static_cast<AudioSources::enAudioSources>(srcID.enSourceClass))
                       , (tU16)srcID.u16SubSource
                       , (tU16)srcID.u16SubSource
                       , (tU16)static_cast<tU16>(gam_sourceID)));
      return gam_sourceID;
   }
   ETG_TRACE_ERR(("Error: enterSourceDB returned error %d for SourceClass: %d subID %#x(%d) "
               ,(tU16)retVal
               ,ETG_CENUM(AudioSources::enAudioSources,static_cast<AudioSources::enAudioSources>(srcID.enSourceClass))
               , (tU16)srcID.u16SubSource
               , (tU16)srcID.u16SubSource));
   return 0;
}



tVoid clGeniviAudioCtrlAdapter::RemoveSource(am_sourceID_t gam_sourceID)
{
   am_Error_e retVal = m_geniviControlIF->removeSourceDB(gam_sourceID);
   if(retVal == E_OK)
   {
      m_registeredSources.erase(gam_sourceID);
   }
}

tVoid clGeniviAudioCtrlAdapter::SourceAvailabilityChange(midw_fi_tcl_e8_AudSource::tenType Source,
                                                        tU16 SubSource,
                                                        midw_fi_tcl_e8_SrcAvailability::tenType Availability,
                                                        midw_fi_tcl_e8_SrcAvailabilityReason::tenType Reason)
{
   ETG_TRACE_USR4(("SourceAvailabilityChange: SourceClass: %d, subID %#x(%d), Availability %d, Reason %d"
            ,ETG_CENUM(midw_fi_tcl_e8_AudSource::tenType,Source)
            , SubSource
            , SubSource
            , ETG_CENUM(midw_fi_tcl_e8_SrcAvailability::tenType, Availability)
            , ETG_CENUM(midw_fi_tcl_e8_SrcAvailabilityReason::tenType, Reason)
            ));

   clAudioSMEngine::Source_AvailabilityChange(
         SourceID( Ext2Int_SrcClass(Source) ,SubSource),
         Ext2Int_Availability(Availability),
         Ext2Int_AvailabilityReason(Reason));

}

tVoid clGeniviAudioCtrlAdapter::AddAudioRouteMgrIF(amcontrol_clienthandler_fc_audioroutemanager* clientHandlerAudioRouteMgr)
{
   m_clientHandlerAudioRouteMgr = clientHandlerAudioRouteMgr;
}

tVoid clGeniviAudioCtrlAdapter::RemoveAudioRouteMgrIF()
{
   m_clientHandlerAudioRouteMgr = NULL;
}

tVoid clGeniviAudioCtrlAdapter::AddGeniviCtrlIF(IAmControlReceive* pGeniviCtrlIF)
{
   m_geniviControlIF = pGeniviCtrlIF;
}

tVoid clGeniviAudioCtrlAdapter::RemoveGeniviCtrlIF()
{
   m_geniviControlIF = NULL;
}

IAmControlReceive* clGeniviAudioCtrlAdapter::GetGeniviCtrlIF()
{
   return m_geniviControlIF;
}

tVoid clGeniviAudioCtrlAdapter::AddDomainID(am_domainID_t domainID)
{
  // ETG_TRACE_USR1(("AddDomainID: m_domainID: %d", domainID));
   m_domainID = domainID;
}

am_Error_e clGeniviAudioCtrlAdapter::hookUserDisconnectionRequest(const am_mainConnectionID_t connectionID)
{

   if(m_geniviControlIF==NULL)
   {
      ETG_TRACE_ERR(("m_geniviControlIF==NULL"));
      return E_UNKNOWN;
   }
   clAudioSMEngine::enErrorCode retVal = clAudioSMEngine::AUDIOSM_ERROR;
   am_MainConnection_s mainConnectionData;
   if(E_OK == m_geniviControlIF->getMainConnectionInfoDB(connectionID, mainConnectionData))
   {
      //get the AudioStack SourceID of given GAM SourceID
      std::map<am_sourceID_t, SourceID >::const_iterator iter = m_registeredSources.find(mainConnectionData.sourceID);
      if(iter != m_registeredSources.begin())
      {
      clAudioSMEngine::enErrorCode retVal =
                  clAudioSMEngine::Source_Off((*iter).second);
      }else{
         //There is no mapping to AudioStack SourceID
         ETG_TRACE_ERR(("hookUserDisconnectionRequest: No registered SourceID found for GAM Source ID %d", mainConnectionData.sourceID))
      }
      //Check if AudioStack was able to remove
      if(retVal != clAudioSMEngine::AUDIOSM_OK)
      {
         return E_NOT_POSSIBLE;
      }else{
         return E_OK;
      }
   }
   //Connection was not found in Genivi DB
   return E_NON_EXISTENT;
}
//
////VVD
//am_Error_e clGeniviAudioCtrlAdapter::hookUserDisConnectionRequest(const am_sourceID_t sourceID,
//                                  const am_sinkID_t sinkID,
//                                  am_mainConnectionID_t& mainConnectionID)
//{
//   clAudioSMEngine::enErrorCode retVal = clAudioSMEngine::Source_Off(static_cast<AudioSources::enAudioSources>(sourceID));
//   if(retVal == clAudioSMEngine::AUDIOSM_OK)
//   {
//      return removeMainConnectionDB(mainConnectionID);
//   }else{
//      return E_UNKNOWN;
//   }
//}

am_Error_e clGeniviAudioCtrlAdapter::hookUserConnectionRequest(const am_sourceID_t sourceID,
                                                                      const am_sinkID_t sinkID,
                                                                      am_mainConnectionID_t& mainConnectionID)
{
   //get the AudioStack SourceID of given GAM SourceID
   std::map<am_sourceID_t, SourceID >::const_iterator iter = m_registeredSources.find(sourceID);
   clAudioSMEngine::enErrorCode retVal = clAudioSMEngine::AUDIOSM_ERROR;
   if(iter != m_registeredSources.end())
   {
      retVal = clAudioSMEngine::Source_On((*iter).second);
   }else{
      ETG_TRACE_ERR(("hookUserConnectionRequest: SourceID: %d is not registered at clGeniviAudioCtrlAdapter" , sourceID));
   }

   if(retVal == clAudioSMEngine::AUDIOSM_OK)
   {
      return addMainConnection(sourceID,sinkID, mainConnectionID);
   }else{
      ETG_TRACE_ERR(("hookUserConnectionRequest: AudioStack returns Error %d for connection request of SourceID: %d" , sourceID, retVal));
      return E_UNKNOWN;
   }
}

am_Error_e clGeniviAudioCtrlAdapter::RequestSourceOff(midw_fi_tcl_e8_AudSource::tenType source, tU16 subID)
{

}

am_Error_e clGeniviAudioCtrlAdapter::RequestSourceOff(SourceID srcID)
{
   if( clAudioSMEngine::Source_Off(srcID) == clAudioSMEngine::AUDIOSM_OK)
   {
      return E_OK;
   }
   return E_NOT_POSSIBLE;
}

am_Error_e clGeniviAudioCtrlAdapter::RequestSourceOff(const am_sourceID_t sourceID)
{
   std::map<am_sourceID_t, SourceID >::const_iterator iter = m_registeredSources.find(sourceID);
   if(iter != m_registeredSources.end())
   {
      return RequestSourceOff((*iter).second);
   }
   return E_NOT_POSSIBLE;
}

am_Error_e clGeniviAudioCtrlAdapter::RequestSourcePause(SourceID srcID)
{
   ETG_TRACE_ERR(("ERROR: RequestSourcePause actually not supported"));
   return E_NOT_USED;
}

am_Error_e clGeniviAudioCtrlAdapter::RequestSourceOn(SourceID srcID)
{
   if( clAudioSMEngine::Source_On(srcID) == clAudioSMEngine::AUDIOSM_OK)
   {
      return E_OK;
   }
   return E_NOT_POSSIBLE;
}

am_Error_e clGeniviAudioCtrlAdapter::RequestSourceOn(const am_sourceID_t sourceID)
{
   std::map<am_sourceID_t, SourceID >::const_iterator iter = m_registeredSources.find(sourceID);
   if(iter != m_registeredSources.end())
   {
      return RequestSourceOn((*iter).second);
   }
   return E_NOT_POSSIBLE;
}

am_Error_e clGeniviAudioCtrlAdapter::SourceActivityRequest(midw_fi_tcl_e8_AudSource::tenType source,
                                                           midw_fi_tcl_e8_AudSource::tenType possibleNextSource,
                                                           midw_fi_tcl_e8_SrcActivity::tenType activity)
{
   am_Error_e retVal = E_OK;
   if(m_clientHandlerAudioRouteMgr != NULL)
   {
      m_clientHandlerAudioRouteMgr->vSourceRouteActivity_Set(source,
          possibleNextSource,
          static_cast<tU8>(midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS),
          activity);
   }
   return retVal;
}

am_Error_e clGeniviAudioCtrlAdapter::disconnect(am_Handle_s& handle, am_connectionID_t connectionID)
{
   am_Error_e retVal = E_UNKNOWN;
   if(m_geniviControlIF==NULL)
   {
      return retVal;
   }
   ETG_TRACE_USR4(("disconnect: request at GAM HandleType: %d Handle %d, connectionID: %d", handle.handleType, handle.handle, connectionID));
   //bAckdisconnect is called before returning from method call
   m_geniviControlIF->disconnect(handle, connectionID);

   ETG_TRACE_USR4(("disconnect: executed at GAM HandleType: %d Handle %d, connectionID: %d", handle.handleType, handle.handle, connectionID));
   return retVal;
}

am_Error_e clGeniviAudioCtrlAdapter::connect(am_Handle_s& handle,
                                                 am_connectionID_t& connectionID,
                                                 am_ConnectionFormat_e format,
                                                 am_sourceID_t sourceID,
                                                 am_sinkID_t sinkID)
{
   if(m_geniviControlIF==NULL)
   {
      return E_UNKNOWN;
   }
   ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::connect"));
   return m_geniviControlIF->connect(handle, connectionID, format, sourceID, sinkID);
}



tVoid clGeniviAudioCtrlAdapter::cbAckDisconnect(const am_Handle_s handle, const am_Error_e errorID)
{
   ETG_TRACE_USR4(("cbAckDisconnect: Handle: %d Error: %d", handle, errorID));
}

tVoid clGeniviAudioCtrlAdapter::cbAckConnect(const am_Handle_s handle, const am_Error_e errorID)
{
   ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::cbAckConnect: Handle: %d Error: %d", handle, errorID));
}

am_Error_e clGeniviAudioCtrlAdapter::changeMainConnectionRouteDB(am_sourceID_t sourceID,  std::vector<am_connectionID_t>& listConnectionID)
{
   if(m_geniviControlIF==NULL)
   {
      return E_UNKNOWN;
   }
   am_mainConnectionID_t mainconnectionID;
   am_Error_e ret = getMainConnectionOfSource(sourceID, mainconnectionID);
   if(E_OK != ret)
   {
      return ret;
   }
   return m_geniviControlIF->changeMainConnectionRouteDB(mainconnectionID, listConnectionID);
}

am_Error_e clGeniviAudioCtrlAdapter::removeMainConnection(am_sourceID_t sourceID)
{
   ETG_TRACE_USR4(("removeMainConnectionDB: GAM SourceID: %d", sourceID));
   //Check active main connections
   am_mainConnectionID_t mainConnectionID;
   am_Error_e ret = getMainConnectionOfSource(sourceID, mainConnectionID);
   if(E_OK != ret)
   {
      return ret;
   }
   ret = removeMainConnectionDB(mainConnectionID);
   if(ret != E_OK)
   {
      ETG_TRACE_USR4(("removeMainConnectionDB: Failed with: %d ", ret));
   }
   return ret;
}

am_Error_e clGeniviAudioCtrlAdapter::removeMainConnectionDB(const am_mainConnectionID_t mainConnectionID)
{
   ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::removeMainConnectionDB: mainConnectionID: %d ", mainConnectionID));
   if(m_geniviControlIF==NULL)
   {
      return E_UNKNOWN;
   }
   return m_geniviControlIF->removeMainConnectionDB( mainConnectionID);
}

am_Error_e clGeniviAudioCtrlAdapter::addMainConnection(am_sourceID_t sourceID)
{
   am_mainConnectionID_t mainConnectionID;
   return addMainConnection(sourceID, GAM_AUDIO_SINK_ID, mainConnectionID);
}


am_Error_e clGeniviAudioCtrlAdapter::addMainConnection(const am_sourceID_t sourceID,
                                                              const am_sinkID_t sinkID,
                                                              am_mainConnectionID_t& mainConnectionID)
{
   if(m_geniviControlIF==NULL)
   {
      return E_NOT_POSSIBLE;
   }

   if(E_OK == getMainConnectionOfSource(sourceID, mainConnectionID))
   {
      return E_ALREADY_EXISTS;
   }

   //TODO delete these Object somewhere
//   stGACA_mainConnectionItem* GACAconnItem = new stGACA_mainConnectionItem();
   //TODO delete these Object somewhere
   am_MainConnection_s mainConnectionData;// = new am_MainConnection_s();

   mainConnectionData.mainConnectionID = 0;
   mainConnectionData.sinkID = sinkID;
   mainConnectionData.sourceID = sourceID;
   mainConnectionData.connectionState = CS_CONNECTING;
   mainConnectionData.delay = 0;

//   GACAconnItem->mainConnection = mainConnectionData;
//   GACAconnItem->handle = NULL;
//   m_mainConnectionList.push_back(GACAconnItem);
   am_Error_e ret;
   ETG_TRACE_USR1(("addMainConnection: enterMainConnectionDB: ID %d, MainConnID %d, Src %d, Snk %d, size %d", mainConnectionID,
         mainConnectionData.mainConnectionID,
         mainConnectionData.sourceID,
         mainConnectionData.sinkID,
         mainConnectionData.listConnectionID.size()));
   ret = m_geniviControlIF->enterMainConnectionDB(mainConnectionData, mainConnectionID);
   ETG_TRACE_USR1(("addMainConnection: new MainConnection: ID %d, Src %d, Snk %d", mainConnectionID, sourceID, sinkID));
   mainConnectionData.mainConnectionID = mainConnectionID;
   return ret;
}

am_Error_e clGeniviAudioCtrlAdapter::getMainConnectionOfSource(am_sourceID_t sourceID, am_mainConnectionID_t& mainConnectionID)
{
   ETG_TRACE_USR4(("getMainConnectionOfSource: Search MainConnection for Source %d"
               , sourceID));

   if(m_geniviControlIF==NULL)
   {
      ETG_TRACE_ERR(("m_geniviControlIF==NULL"));
      return E_UNKNOWN;
   }

   std::vector<am_MainConnection_s> listMainConnections;
   m_geniviControlIF->getListMainConnections(listMainConnections);
   std::vector<am_MainConnection_s>::iterator iter = listMainConnections.begin();
   //Check for equal MainConnections
   while(iter != listMainConnections.end())
   {
      if((*iter).sourceID == sourceID)
      {
         ETG_TRACE_USR4(("getMainConnectionOfSource: Found MainConnection: ID %d, Src %d, Snk %d"
               ,(*iter).mainConnectionID
               ,(*iter).sourceID
               ,(*iter).sinkID));
         mainConnectionID = (*iter).mainConnectionID;
         return E_OK;
      }
      ++iter;
   }
   ETG_TRACE_USR4(("getMainConnectionOfSource: No MainConnection for Source %d", sourceID));
   return E_NON_EXISTENT;
}

am_Error_e clGeniviAudioCtrlAdapter::getConnectionOfSource(AudioSources::enAudioSources sourceID, am_connectionID_t& connectionID)
{
   ETG_TRACE_USR4(("getConnectionOfSource: Search Connection for Source %d"
               , sourceID));

   if(m_geniviControlIF==NULL)
   {
      ETG_TRACE_ERR(("m_geniviControlIF==NULL"));
      return E_UNKNOWN;
   }

   std::vector<am_Connection_s> listConnections;
   m_geniviControlIF->getListConnections(listConnections);
   std::vector<am_Connection_s>::iterator iter = listConnections.begin();
   //Check for equal MainConnections
   while(iter != listConnections.end())
   {
      if((*iter).sourceID == static_cast<am_sourceID_t>(sourceID))
      {
         ETG_TRACE_USR4(("getMainConnectionOfSource: Found Connection: ID %d, Src %d, Snk %d"
               ,(*iter).connectionID
               ,(*iter).sourceID
               ,(*iter).sinkID));
         connectionID = (*iter).connectionID;
         return E_OK;
      }
      ++iter;
   }
   ETG_TRACE_USR4(("getConnectionOfSource: No Connection for Source %d", sourceID));
   return E_NON_EXISTENT;
}


am_Error_e clGeniviAudioCtrlAdapter::changeMainConnectionStateDB(const am_sourceID_t sourceID,
                                                                        const am_sinkID_t sinkID,
                                                                        const am_ConnectionState_e connectionState)
{
   (void) sinkID;
   ETG_TRACE_USR3(("changeMainConnectionStateDB: source %d, connectionState %d",
               ETG_CENUM(AudioSources::enAudioSources, sourceID),
               ETG_CENUM(am_ConnectionState_e, connectionState)));

   if(m_geniviControlIF==NULL)
   {
      ETG_TRACE_ERR(("m_geniviControlIF==NULL"));
      return E_UNKNOWN;
   }

   am_mainConnectionID_t mainConnectionID;
   am_Error_e ret = getMainConnectionOfSource(static_cast<AudioSources::enAudioSources>(sourceID), mainConnectionID);
   if(E_OK != ret)
   {
      return ret;
   }
   return m_geniviControlIF->changeMainConnectionStateDB(mainConnectionID, connectionState);
}

am_Error_e clGeniviAudioCtrlAdapter::setSourceState(am_Handle_s& handle,
      const am_sourceID_t sourceID, am_SourceState_e state)
{
   ETG_TRACE_USR3(("setSourceState: source %d, state %d",
            ETG_CENUM(AudioSources::enAudioSources, sourceID),
            ETG_CENUM(am_SourceState_e, state)));
   return m_geniviControlIF->setSourceState(handle, sourceID, state);
}

void clGeniviAudioCtrlAdapter::cbAckSourceState(const am_Handle_s handle, const am_Error_e error)
{
   ETG_TRACE_USR4(("cbAckSourceState: handle %d, handleType %d, errorID: %d"
               , handle.handle
               , handle.handleType
               , error));
}

AudioSources::enAudioSources clGeniviAudioCtrlAdapter::Ext2Int_SrcClass(midw_fi_tcl_e8_AudSource::tenType enSrcExt)
{
   AudioSources::enAudioSources enSrcInternal = AudioSources::NONE;
   ETG_TRACE_USR4(("ExternalSrcClass_2_InternalSrcClass: External/midw_fi source id %d",
         ETG_CENUM(midw_fi_tcl_e8_AudSource::tenType, enSrcExt)));

   //First check if there is a registered source that matches
   std::map<am_sourceID_t, SourceID >::iterator iter = m_registeredSources.begin();
   while(iter != m_registeredSources.end())
   {
      if(clStackRules::rules[clStackRules::ruleIndex((*iter).second)].externalID == static_cast<tU16>(enSrcExt))
      {
         enSrcInternal = (*iter).second.enSourceClass;

         ETG_TRACE_USR2(("ExternalSrcClass_2_InternalSrcClass: external class: %d mapped to internal class: %d",
               ETG_CENUM(midw_fi_tcl_e8_AudSource::tenType,enSrcExt),
               ETG_CENUM(AudioSources::enAudioSources,enSrcInternal)));
         return enSrcInternal;
      }
      ++iter;
   }
   //We haven't found a match we'll look at others
   ETG_TRACE_USR2(("ExternalSrcClass_2_InternalSrcClass:: no mapping found in registered sources, looking in ruleset..."));
   // as long as we do not have stl container we'll iterate through array
   int i = 0;
   do
   {
      midw_fi_tcl_e8_AudSource::tenType extSrcID = static_cast<midw_fi_tcl_e8_AudSource::tenType>(clStackRules::rules[i].externalID);
      AudioSources::enAudioSources intSrcID = static_cast<AudioSources::enAudioSources>(clStackRules::rules[i].src);
      ETG_TRACE_USR4(("ExternalSrcClass_2_InternalSrcClass: clStackRules=>ExtSrcID : %d, Mapped to IntSrcID : %d",
            ETG_CENUM(midw_fi_tcl_e8_AudSource::tenType,extSrcID),
            ETG_CENUM(AudioSources::enAudioSources,intSrcID)));
      if(clStackRules::rules[i].externalID == enSrcExt)
      {
         enSrcInternal = clStackRules::rules[i].src;
         ETG_TRACE_USR2(("ExternalSrcClass_2_InternalSrcClass: external source : %d Mapped to internal source : %d",
               ETG_CENUM(midw_fi_tcl_e8_AudSource::tenType,enSrcExt),
               ETG_CENUM(AudioSources::enAudioSources,enSrcInternal)));
         return enSrcInternal;
      }
      ++i;
   }
   while((clStackRules::rules[i].src != AudioSources::LAST)&&(i != AudioSources::LAST));
   return AudioSources::NONE;
}

//tBool clGeniviAudioCtrlAdapter::bIsAudioMuted()
//{
//  ETG_TRACE_USR2(("clGeniviAudioCtrlAdapter::bIsAudioMuted"));
//  return clAudioSourceController::getInstance().bIsAudioMuted();
//}

tBool clGeniviAudioCtrlAdapter::bIsCurrentActiveAudiosource(SourceID srcID)
{
  tBool retVal = clAudioSourceController::getInstance().bIsCurrentActiveAudiosource(srcID);
  ETG_TRACE_USR4(("bIsCurrentActiveAudiosource: SourceClass: %d subID %#x(%d): %d"
      ,ETG_CENUM(AudioSources::enAudioSources,static_cast<AudioSources::enAudioSources>(srcID.enSourceClass))
      , (tU16)srcID.u16SubSource
      , (tU16)srcID.u16SubSource
      , retVal));
  return retVal;
}

//vHandleSrcActError
void clGeniviAudioCtrlAdapter::vHandleSourceError(midw_fi_tcl_e8_AudSource::tenType errSrc)
{
   //TODO: Open Point identified:
   //received Information insufficient, need additional SubSource Information
   //which is actually not transmitted
   //Send Mail 11.11.2013 4pm
   ETG_TRACE_ERR(("vHandleSourceError: CANNOT HANDLE ERROR CORRECTLY, ABORTING ERROR HANDLING FOR SOURCE CLASS %d",
           ETG_CENUM(midw_fi_tcl_e8_AudSource::tenType, errSrc)));

//  ETG_TRACE_USR3(("vHandleSourceError: error source id %d",
//           ETG_CENUM(midw_fi_tcl_e8_AudSource::tenType, errSrc)));
//
//  bpstl::list<clGeniviAudioSource * >::iterator iter = m_registeredSources.begin();
//  while(iter != m_registeredSources.end())
//  {
//    if(((*iter) != NULL ) && ((*iter)->getExternalId() == static_cast<tS32>(errSrc)))
//    {
//      AudioSources::enAudioSources errSrcInternal = static_cast<AudioSources::enAudioSources>((*iter)->sGetId().enSourceClass);
//
//      ETG_TRACE_USR4(("vHandleSourceError: external source %d Mapped to internal source class %d",
//               ETG_CENUM(midw_fi_tcl_e8_AudSource::tenType,errSrc),
//               ETG_CENUM(AudioSources::enAudioSources,errSrcInternal)));
//       clAudioSMEngine::vHandleSrcActError(SourceID{errSrcInternal,0});
//    }
//    ++iter;
//  }
}

void clGeniviAudioCtrlAdapter::handleSourceStatus(midw_fi_tcl_e8_SrcActivity::tenType activity, midw_fi_tcl_e8_AudSource::tenType source, tU16 subSrc)
{
   ETG_TRACE_USR3(("handleSourceStatus: external source id %d, activity %d",
         ETG_CENUM(midw_fi_tcl_e8_AudSource::tenType, source),
         ETG_CENUM(midw_fi_tcl_e8_SrcActivity::tenType, activity)));


   // We go to all registered source
   // and notify all with the corresponding SourceClass
   // because there might be more than one that matches
   std::map<am_sourceID_t, SourceID >::iterator iter = m_registeredSources.begin();
   while(iter != m_registeredSources.end())
   {

      clAudioSource* pSrc = clAudioSourceFactory::getAudioSource((*iter).second);

      if((pSrc != NULL ) && (pSrc->getExternalId() == static_cast<tS32>(source)))
      {
         ETG_TRACE_USR4(("handleSourceStatus: Inform internal source %d, activity %d",
               ETG_CENUM(AudioSources::enAudioSources,source),
               ETG_CENUM(clGeniviAudioSource::enSourceActivity,activity)));
         pSrc->vMW_CCAResponse(static_cast<tS32>(source), Ext2Int_Activity(activity));
      }
      ++iter;
   }
}


} //namespace

